# Controleer of script als admin draait
if (-not ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole(
    [Security.Principal.WindowsBuiltInRole] "Administrator")) {
    Write-Host "Herstart als administrator..." -ForegroundColor Yellow
    Start-Process powershell "-ExecutionPolicy Bypass -File `"$PSCommandPath`"" -Verb RunAs
    exit
}

# Zet huidige directory naar de map van dit script
Set-Location -Path (Split-Path -Parent $MyInvocation.MyCommand.Definition)

# Doelmap in Program Files
$targetDir = "$env:ProgramFiles\Rekenmachine Grafisch"
$startMenuDir = "$env:ProgramData\Microsoft\Windows\Start Menu\Programs\Rekenmachine Grafisch"

# Maak de doelmap aan (verwijder eerst bestaande bestanden)
if (Test-Path $targetDir) {
    Write-Host "Verwijder bestaande installatie..." -ForegroundColor Yellow
    Remove-Item $targetDir -Recurse -Force
}
New-Item -ItemType Directory -Force -Path $targetDir | Out-Null

# Kopieer programmabestanden
Write-Host "Kopieer programmabestanden naar $targetDir" -ForegroundColor Cyan
Copy-Item -Path ".\gr\*" -Destination $targetDir -Recurse -Force

# Kopieer ook het uninstall script naar dezelfde map
Copy-Item -Path ".\Uninstall.ps1" -Destination $targetDir -Force

# Startmenu-map aanmaken
Write-Host "Maak snelkoppelingen in het startmenu..." -ForegroundColor Cyan
New-Item -ItemType Directory -Force -Path $startMenuDir | Out-Null

# Pad naar programma en uninstall-script
$exePath = Join-Path $targetDir "Rekenmachine-Grafisch.exe"
$icoPath = Join-Path $targetDir "Rekenmachine-Grafisch.ico"
$uninstallPath = Join-Path $targetDir "Uninstall.ps1"

# Functie voor het maken van een snelkoppeling
function New-Shortcut($shortcutPath, $targetPath, $description, $iconLocation) {
    $WshShell = New-Object -ComObject WScript.Shell
    $shortcut = $WshShell.CreateShortcut($shortcutPath)
    $shortcut.TargetPath = $targetPath
    $shortcut.WorkingDirectory = Split-Path $targetPath
    $shortcut.Description = $description
    if (Test-Path $iconLocation) {
        $shortcut.IconLocation = $iconLocation
    }
    $shortcut.Save()
}

# Maak snelkoppeling naar programma (gebruik eigen icoon indien aanwezig)
if (Test-Path $icoPath) {
    $icon = $icoPath
} else {
    $icon = $exePath  # gebruik exe-icoon
}
New-Shortcut -shortcutPath (Join-Path $startMenuDir "Rekenmachine Grafisch.lnk") `
             -targetPath $exePath `
             -description "Start Rekenmachine Grafisch" `
             -iconLocation $icon

# Maak snelkoppeling naar uninstall-script (met standaard verwijdericoon)
$uninstallShortcut = (Join-Path $startMenuDir "Verwijderen Rekenmachine Grafisch.lnk")
$WshShell = New-Object -ComObject WScript.Shell
$shortcut = $WshShell.CreateShortcut($uninstallShortcut)
$shortcut.TargetPath = "powershell.exe"
$shortcut.Arguments = "-ExecutionPolicy Bypass -File `"$uninstallPath`""
$shortcut.IconLocation = "shell32.dll,131"
$shortcut.Description = "Verwijder Rekenmachine Grafisch van deze computer"
$shortcut.Save()

Write-Host "`n✅ Installatie voltooid!" -ForegroundColor Green
