# ===============================================
# Rekenmachine Grafisch - Uninstall Script
# ===============================================

# Controleer of script als admin draait
if (-not ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole(
    [Security.Principal.WindowsBuiltInRole] "Administrator")) {
    Write-Host "Herstart als administrator..." -ForegroundColor Yellow
    Start-Process powershell "-ExecutionPolicy Bypass -File `"$PSCommandPath`"" -Verb RunAs
    exit
}

# Verplaats de working directory zodat de map vrij is
Set-Location -Path $env:TEMP

# Definieer paden
$targetDir = "$env:ProgramFiles\Rekenmachine Grafisch"
$startMenuDir = "$env:ProgramData\Microsoft\Windows\Start Menu\Programs\Rekenmachine Grafisch"

Write-Host "=== Verwijderen van Rekenmachine Grafisch gestart ===" -ForegroundColor Cyan
Write-Host ""

# Verwijder Startmenu-items
if (Test-Path $startMenuDir) {
    try {
        Remove-Item $startMenuDir -Recurse -Force -ErrorAction Stop
        Write-Host "Startmenu-items verwijderd." -ForegroundColor Green
    } catch {
        Write-Host "Kon Startmenu-items niet verwijderen: $_" -ForegroundColor Red
    }
} else {
    Write-Host "Geen Startmenu-items gevonden."
}

# Verwijder programmamap
if (Test-Path $targetDir) {
    try {
        Remove-Item $targetDir -Recurse -Force -ErrorAction Stop
        Write-Host "Programmabestanden verwijderd." -ForegroundColor Green
    } catch {
        Write-Host "Kon programmamap niet verwijderen. Sluit het programma en probeer opnieuw." -ForegroundColor Red
    }
} else {
    Write-Host "Geen programmamap gevonden."
}

Write-Host ""
Write-Host "=== Rekenmachine Grafisch volledig verwijderd ===" -ForegroundColor Cyan
Pause
